/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.hwmca.base.authcode;

import com.ibm.hwmca.base.authcode.AuthInternalCodeChangeBean;
import com.ibm.hwmca.base.authcode.AuthInternalCodeChangeErrorIds;
import com.ibm.hwmca.base.authcode.AuthInternalCodeChangeUtil;
import com.ibm.hwmca.base.managed.BaseTower;
import com.ibm.hwmca.base.util.BaseTextBundle;
import com.ibm.hwmca.base.util.SimServer;
import com.ibm.hwmca.fw.HException;
import com.ibm.hwmca.fw.log.FrameworkEventText;
import com.ibm.hwmca.fw.log.FrameworkLog;
import com.ibm.hwmca.fw.log.SystemEventLog;
import com.ibm.hwmca.fw.managed.Task;
import com.ibm.hwmca.fw.task.HwmcaPanelTasklet;
import com.ibm.hwmca.fw.task.ProgressCancelListener;
import com.ibm.hwmca.fw.task.ProgressData;
import com.ibm.hwmca.fw.task.ProgressEndEvent;
import com.ibm.hwmca.fw.task.ProgressEndedListener;
import com.ibm.hwmca.fw.task.ProgressStartEvent;
import com.ibm.hwmca.fw.task.UserContext;
import com.ibm.hwmca.fw.tasklet.PanelTaskletProgressListener;
import com.ibm.hwmca.fw.tasklet.PanelTaskletRequest;
import com.ibm.hwmca.fw.tasklet.PanelTaskletResponse;
import com.ibm.hwmca.fw.tasklet.TaskletException;
import com.ibm.hwmca.fw.util.LocalizableText;
import com.ibm.hwmca.fw.util.Trace;
import com.ibm.hwmca.fw.util.Translator;
import com.ibm.ui.framework.TaskActionEvent;

public class AuthInternalCodeChangeTasklet
extends HwmcaPanelTasklet
implements ProgressEndedListener,
AuthInternalCodeChangeErrorIds {
    private static final String TRACE_MASKT = "XMCMACMT";
    private static final String TRACE_MASKF = "XMCMACMF";
    private static final String TRACE_MASKD = "XMCMACMD";
    private static final String AUIML_FILE_NAME = "com.ibm.hwmca.base.authcode.res.AuthInternalCodeChangeRes";
    private static final String AUTHCODE_PANEL = "AuthInternalCodeChangePanel";
    private Boolean disableRequest;
    private boolean waitOnInProgressOkButton;
    private LocalizableText taskName;

    public AuthInternalCodeChangeTasklet() {
        Trace.trace(TRACE_MASKT, "<> AuthInternalCodeChangeTasklet() constructor");
    }

    public void service(PanelTaskletRequest taskletRequest, PanelTaskletResponse taskletResponse) throws TaskletException {
        Trace.trace(TRACE_MASKT, "-> AuthInternalCodeChangeTasklet.service()");
        try {
            if (taskletRequest.isInitialRequest()) {
                this.setExplicitTerminate(true);
                AuthInternalCodeChangeBean authInternalCodeChangeBean = new AuthInternalCodeChangeBean(AUTHCODE_PANEL);
                Task task = this.getTask();
                this.taskName = task.getUIInfo().getUnlocalizedName();
                boolean hmcDisabled = BaseTower.getBaseTower().isUpdatingDisabled();
                authInternalCodeChangeBean.setInitialAuthorizeDisabled(hmcDisabled);
                taskletResponse.replace(AUIML_FILE_NAME, AUTHCODE_PANEL, authInternalCodeChangeBean);
            } else if (taskletRequest.isDisposed() || taskletRequest.isCanceled()) {
                taskletResponse.terminate();
            } else if (taskletRequest.getData("Terminate") == null) {
                TaskActionEvent event = (TaskActionEvent)taskletRequest.getData("event");
                Trace.trace(TRACE_MASKF, "event is: " + event.getElementName());
                if (event.getElementName().equals("SaveButton")) {
                    Trace.trace(TRACE_MASKF, "Tasklet Save Button processing");
                    this.disableRequest = (Boolean)taskletRequest.getData("RequestDisable");
                    taskletResponse.dispose(AUTHCODE_PANEL);
                    ExecuteSave executeSave = new ExecuteSave();
                    Thread executeSaveThread = new Thread(executeSave);
                    executeSaveThread.setDaemon(true);
                    executeSaveThread.setName("authcodeExecuteSaveThread");
                    executeSaveThread.start();
                } else if (event.getElementName().equals("CancelButton")) {
                    Trace.trace(TRACE_MASKF, "doing a cancel (terminate) on only panel");
                    taskletResponse.terminate();
                } else {
                    Trace.trace(TRACE_MASKF, "doing a no action");
                    taskletResponse.noAction();
                }
            } else {
                Trace.trace(TRACE_MASKF, "Tasklet terminate() after function performed");
                taskletResponse.terminate();
            }
        }
        catch (Exception e) {
            Trace.trace(TRACE_MASKF, "Exception during AuthInternalCodeChangeTasklet.service(): " + e);
            Trace.trace(TRACE_MASKF, "The Stack Trace is as follows:");
            Trace.trace(TRACE_MASKF, e);
            Trace.trace(TRACE_MASKF, "End of Stack Trace");
            if (e instanceof TaskletException) {
                throw (TaskletException)e;
            }
            throw new TaskletException(e);
        }
        Trace.trace(TRACE_MASKT, "<- AuthInternalCodeChangeTasklet.service()");
    }

    public void logException(Throwable throwable) {
        Trace.trace(TRACE_MASKT, "-> AuthInternalCodeChangeTasklet.logException()");
        Trace.trace(TRACE_MASKT, "processing exception: " + throwable);
        new FrameworkLog(AuthInternalCodeChangeErrorIds.LOGINFO, 2320, throwable).log();
        Trace.trace(TRACE_MASKT, "<- AuthInternalCodeChangeTasklet.logException()");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void progressEnded(String id) {
        Trace.trace(TRACE_MASKT, "-> AuthInternalCodeChangeTasklet.progressEnded()");
        AuthInternalCodeChangeTasklet authInternalCodeChangeTasklet = this;
        synchronized (authInternalCodeChangeTasklet) {
            this.waitOnInProgressOkButton = false;
            this.notifyAll();
        }
        Trace.trace(TRACE_MASKT, "<- AuthInternalCodeChangeTasklet.progressEnded()");
    }

    public static void bdvSleep(int milliseconds) {
        Trace.trace(TRACE_MASKT, "-> AuthInternalCodeChangeTasklet.bdvSleep()");
        while (milliseconds > 0) {
            long loopStartTime = System.currentTimeMillis();
            try {
                Thread.currentThread();
                Thread.sleep(milliseconds);
            }
            catch (InterruptedException e) {
                // empty catch block
            }
            milliseconds = (int)((long)milliseconds - (System.currentTimeMillis() - loopStartTime));
        }
        Trace.trace(TRACE_MASKT, "<- AuthInternalCodeChangeTasklet.bdvSleep()");
    }

    private class ExecuteSave
    implements Runnable {
        private ExecuteSave() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void run() {
            HException hException;
            Trace.trace(AuthInternalCodeChangeTasklet.TRACE_MASKF, "-> AuthInternalCodeChangeTasklet.ExecuteSave.run()");
            try {
                Trace.trace(AuthInternalCodeChangeTasklet.TRACE_MASKF, "about to enter synchronized block in ExecuteSave.run()");
                AuthInternalCodeChangeTasklet authInternalCodeChangeTasklet = AuthInternalCodeChangeTasklet.this;
                synchronized (authInternalCodeChangeTasklet) {
                    this.systemEvent();
                    AuthInternalCodeChangeUtil authInternalCodeChangeUtil = new AuthInternalCodeChangeUtil();
                    ProgressData[] progressData = authInternalCodeChangeUtil.getProgressData();
                    String progressId = new String(AuthInternalCodeChangeTasklet.this.taskName.getKey());
                    PanelTaskletProgressListener progListener = new PanelTaskletProgressListener(AuthInternalCodeChangeTasklet.this);
                    long duration = 180L;
                    LocalizableText inProgressText = new LocalizableText("com/ibm/hwmca/fw/res/common", "progress.in_progress");
                    ProgressStartEvent progressStartEvent = new ProgressStartEvent(AuthInternalCodeChangeTasklet.this.taskName, progressData, duration, inProgressText, progressId, (ProgressCancelListener)null, (ProgressEndedListener)AuthInternalCodeChangeTasklet.this);
                    progListener.startProgress(progressStartEvent);
                    AuthInternalCodeChangeTasklet.bdvSleep(8000);
                    authInternalCodeChangeUtil.execute(AuthInternalCodeChangeTasklet.this.disableRequest, progressId, AuthInternalCodeChangeTasklet.this, AuthInternalCodeChangeTasklet.this.presentationTaskParms);
                    AuthInternalCodeChangeTasklet.this.waitOnInProgressOkButton = true;
                    progListener.endProgress(new ProgressEndEvent(progressId));
                    while (AuthInternalCodeChangeTasklet.this.waitOnInProgressOkButton) {
                        try {
                            Trace.trace(AuthInternalCodeChangeTasklet.TRACE_MASKF, "wait on In Progress window to be dismissed");
                            AuthInternalCodeChangeTasklet.this.wait();
                            Trace.trace(AuthInternalCodeChangeTasklet.TRACE_MASKF, "wait on In Progress window signal received");
                        }
                        catch (InterruptedException exc) {
                            // empty catch block
                        }
                    }
                }
            }
            catch (Exception e) {
                Trace.trace(AuthInternalCodeChangeTasklet.TRACE_MASKF, "AuthInternalCodeChangeTasklet.ExecuteSave.run() Exception = " + e);
                Trace.trace(AuthInternalCodeChangeTasklet.TRACE_MASKF, "The Stack Trace is as follows:");
                Trace.trace(AuthInternalCodeChangeTasklet.TRACE_MASKF, e);
                Trace.trace(AuthInternalCodeChangeTasklet.TRACE_MASKF, "End of Stack Trace");
                hException = new HException(e);
                new FrameworkLog(AuthInternalCodeChangeErrorIds.LOGINFO, 2323, hException).log();
            }
            try {
                PanelTaskletRequest request = new PanelTaskletRequest();
                request.setData("Terminate", Boolean.TRUE);
                Trace.trace(AuthInternalCodeChangeTasklet.TRACE_MASKD, "about to postRequest() for Terminate");
                AuthInternalCodeChangeTasklet.this.postRequest(null, request);
            }
            catch (TaskletException te) {
                Trace.trace(AuthInternalCodeChangeTasklet.TRACE_MASKF, "postRequest() Exception during AuthInternalCodeChangeTasklet.ExecuteSave.run(): " + te);
                Trace.trace(AuthInternalCodeChangeTasklet.TRACE_MASKF, "The Stack Trace is as follows:");
                Trace.trace(AuthInternalCodeChangeTasklet.TRACE_MASKF, te);
                Trace.trace(AuthInternalCodeChangeTasklet.TRACE_MASKF, "End of Stack Trace");
                hException = new HException(te);
                new FrameworkLog(AuthInternalCodeChangeErrorIds.LOGINFO, 2322, hException).log();
                AuthInternalCodeChangeTasklet.this.abnormalTerminate();
            }
            Trace.trace(AuthInternalCodeChangeTasklet.TRACE_MASKF, "<- AuthInternalCodeChangeTasklet.ExecuteSave.run()");
        }

        public void systemEvent() {
            Trace.trace(AuthInternalCodeChangeTasklet.TRACE_MASKF, "-> AuthInternalCodeChangeTasklet.ExecuteSave.systemEvent()");
            try {
                LocalizableText localizableText;
                String[] substitution = new String[6];
                if (AuthInternalCodeChangeTasklet.this.disableRequest.booleanValue()) {
                    localizableText = new LocalizableText(BaseTextBundle.getBundleName(), "aicc.disable.text");
                    substitution[0] = localizableText.toString();
                } else {
                    localizableText = new LocalizableText(BaseTextBundle.getBundleName(), "aicc.enable.text");
                    substitution[0] = localizableText.toString();
                }
                String tempString = new String();
                SimServer simServer = SimServer.getSimServer();
                byte[] hmcNau = simServer.readSim(7);
                tempString = Translator.fromAsciiz(hmcNau);
                substitution[1] = substitution[4] = tempString.trim();
                byte[] hmcNetid = simServer.readSim(6);
                tempString = Translator.fromAsciiz(hmcNetid);
                substitution[2] = substitution[5] = tempString.trim();
                UserContext userContext = UserContext.getCurrentUserContext();
                substitution[3] = "HMC(" + userContext.getUserid() + ")";
                FrameworkEventText frameworkEventText = new FrameworkEventText(865, substitution);
                String eventName = "AUTHCODE";
                SystemEventLog systemEventLog = new SystemEventLog(frameworkEventText, eventName);
                systemEventLog.log();
            }
            catch (HException hException) {
                Trace.trace(AuthInternalCodeChangeTasklet.TRACE_MASKF, "Exception occurred in AuthInternalCodeChangeTasklet.ExecuteSave.systemEvent().");
                new FrameworkLog(AuthInternalCodeChangeErrorIds.LOGINFO, 2321, hException).log();
            }
            Trace.trace(AuthInternalCodeChangeTasklet.TRACE_MASKF, "<- AuthInternalCodeChangeTasklet.ExecuteSave.systemEvent()");
        }
    }
}

